using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace UsingTheEventKeyword
{
	// Klasa suca do przechowywania informacji o zdarzeniu
	// w tym przypadku zawiera jedynie dane dostpne w 
	// klasie Clock, ale mona take przechowywa 
	// dodatkowe informacje o stanie
	public class TimeInfoEventArgs : EventArgs
	{
		public readonly int hour;
		public readonly int minute;
		public readonly int second;
		public TimeInfoEventArgs(int hour, int minute, int second)
		{
			this.hour = hour;
			this.minute = minute;
			this.second = second;
		}
	}

	// Podmiot programu  to t klas obserwuj inne klasy.
	// Ta klasa publikuje jedno zdarzenie: SecondChanged.
	// Obserwatorzy subskrybuj to zdarzenie
	public class Clock
	{
		private int hour;
		private int minute;
		private int second;

		// Delegat, ktrego musz implementowa subskrybenty
		public delegate void SecondChangeHandler
		   (
		   object clock,
		   TimeInfoEventArgs timeInformation
		   );

		// Sowo kluczowe ogranicza dostp do poniszego delegata
		public event SecondChangeHandler SecondChanged;

		// Uruchamianie zegara.
		// Zegar powoduje zgaszanie zdarzenia przy kadej zmianie sekundy
		public void Run()
		{

			for (; ; )
			{
				// Upienie wtku na 10 milisekund
				Thread.Sleep(10);

				// Pobieranie biecego czasu
				System.DateTime dt = System.DateTime.Now;

				// Jeli sekunda zmienia si,
				// naley powiadomi subskrybentw
				if (dt.Second != second)
				{
					// Tworzenie obiektu typu TimeInfoEventArgs 
					// przekazywanego subskrybentom
					TimeInfoEventArgs timeInformation =
					   new TimeInfoEventArgs(
						  dt.Hour, dt.Minute, dt.Second);

					// Jeli istniej subskrybenty, naley je poinformowa
					if (SecondChanged != null)
					{
						SecondChanged(
						this, timeInformation);
					}
				}

				// Aktualizacja stanu
				this.second = dt.Second;
				this.minute = dt.Minute;
				this.hour = dt.Hour;

			}
		}
	}

	// Obserwator. Klasa DisplayClock subskrybuje
	// zdarzenia zegara. Zadaniem obiektu tej klasy 
	// jest wywietlanie biecego czasu
	public class DisplayClock
	{
		// Przyjmuje zegar i subskrybuje
		// jego zdarzenie, SecondChangeHandler
		public void Subscribe(Clock theClock)
		{
			theClock.SecondChanged +=
			   new Clock.SecondChangeHandler(TimeHasChanged);
		}

		// Metoda zawierajca 
		// delegowan funkcjonalno
		public void TimeHasChanged(
		   object theClock, TimeInfoEventArgs ti)
		{
			Console.WriteLine("Biecy czas: {0}:{1}:{2}",
			   ti.hour.ToString(),
			   ti.minute.ToString(),
			   ti.second.ToString());
		}
	}

	// Drugi subskrybent, zapisujcy informacje do pliku
	public class LogCurrentTime
	{
		public void Subscribe(Clock theClock)
		{
			theClock.SecondChanged +=
			   new Clock.SecondChangeHandler(WriteLogEntry);
		}

		// Ta metoda powinna zapisywa informacje do pliku.
		// Tu wywietla je w oknie konsoli, co pozwala zobaczy, 
		// e obiekt nie przechowuje stanu
		public void WriteLogEntry(
		   object theClock, TimeInfoEventArgs ti)
		{
			Console.WriteLine("Zapis do pliku: {0}:{1}:{2}",
			   ti.hour.ToString(),
			   ti.minute.ToString(),
			   ti.second.ToString());
		}
	}

	public class Test
	{
		public static void Main()
		{
			// Tworzy nowy zegar
			Clock theClock = new Clock();

			// Tworzy obiekt klasy DisplayClock i nakazuje
			// subskrypcj zdarze utworzonego wczeniej zegara
			DisplayClock dc = new DisplayClock();
			dc.Subscribe(theClock);

			// Tworzy obiekt klasy LogCurrentTime i nakazuje
			// subskrypcj zdarze zegara
			LogCurrentTime lct = new LogCurrentTime();
			lct.Subscribe(theClock);

			// Uruchamia zegar
			theClock.Run();
		}
	}
}
